/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.fabric;

import com.google.common.base.Preconditions;
import com.starfish_studios.naturalist.Naturalist;
import com.starfish_studios.naturalist.entity.Bear;
import com.starfish_studios.naturalist.entity.Bird;
import com.starfish_studios.naturalist.entity.Boar;
import com.starfish_studios.naturalist.entity.Butterfly;
import com.starfish_studios.naturalist.entity.Caterpillar;
import com.starfish_studios.naturalist.entity.Deer;
import com.starfish_studios.naturalist.entity.Elephant;
import com.starfish_studios.naturalist.entity.Firefly;
import com.starfish_studios.naturalist.entity.Giraffe;
import com.starfish_studios.naturalist.entity.Hippo;
import com.starfish_studios.naturalist.entity.Lion;
import com.starfish_studios.naturalist.entity.Rhino;
import com.starfish_studios.naturalist.entity.Snail;
import com.starfish_studios.naturalist.entity.Snake;
import com.starfish_studios.naturalist.entity.Vulture;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistMobCategories;
import com.starfish_studios.naturalist.registry.NaturalistTags;
import com.starfish_studios.naturalist.registry.fabric.NaturalistConfigFabric;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1496;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_6862;
import net.minecraft.class_6908;

public class NaturalistFabric
implements ModInitializer {
    public void onInitialize() {
        AutoConfig.register(NaturalistConfigFabric.class, GsonConfigSerializer::new);
        Naturalist.init();
        this.addSpawns();
        this.registerEntityAttributes();
        Naturalist.registerBrewingRecipes();
        Naturalist.registerCompostables();
        Naturalist.registerSpawnPlacements();
    }

    void registerEntityAttributes() {
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.SNAIL.get(), (class_5132.class_5133)Snail.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.BEAR.get(), (class_5132.class_5133)Bear.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.BUTTERFLY.get(), (class_5132.class_5133)Butterfly.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.FIREFLY.get(), (class_5132.class_5133)Firefly.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.SNAKE.get(), (class_5132.class_5133)Snake.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.CORAL_SNAKE.get(), (class_5132.class_5133)Snake.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.RATTLESNAKE.get(), (class_5132.class_5133)Snake.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.DEER.get(), (class_5132.class_5133)Deer.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.BLUEJAY.get(), (class_5132.class_5133)Bird.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.CANARY.get(), (class_5132.class_5133)Bird.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.CARDINAL.get(), (class_5132.class_5133)Bird.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.ROBIN.get(), (class_5132.class_5133)Bird.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.CATERPILLAR.get(), (class_5132.class_5133)Caterpillar.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.RHINO.get(), (class_5132.class_5133)Rhino.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.LION.get(), (class_5132.class_5133)Lion.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.ELEPHANT.get(), (class_5132.class_5133)Elephant.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.ZEBRA.get(), (class_5132.class_5133)class_1496.method_26899());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.GIRAFFE.get(), (class_5132.class_5133)Giraffe.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.HIPPO.get(), (class_5132.class_5133)Hippo.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.VULTURE.get(), (class_5132.class_5133)Vulture.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.BOAR.get(), (class_5132.class_5133)Boar.createAttributes());
    }

    void addSpawns() {
        NaturalistConfigFabric config = (NaturalistConfigFabric)AutoConfig.getConfigHolder(NaturalistConfigFabric.class).getConfig();
        this.addMobSpawn(NaturalistTags.Biomes.HAS_BEAR, class_1311.field_6294, NaturalistEntityTypes.BEAR.get(), config.bearSpawnWeight, 1, 2);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_DEER, class_1311.field_6294, NaturalistEntityTypes.DEER.get(), config.deerSpawnWeight, 1, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_SNAIL, class_1311.field_6294, NaturalistEntityTypes.SNAIL.get(), config.snailSpawnWeight, 1, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_FIREFLY, NaturalistMobCategories.getFireflyCategory(), NaturalistEntityTypes.FIREFLY.get(), config.fireflySpawnWeight, 2, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_BUTTERFLY, class_1311.field_6294, NaturalistEntityTypes.BUTTERFLY.get(), config.butterflySpawnWeight, 1, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_SNAKE, class_1311.field_6294, NaturalistEntityTypes.SNAKE.get(), config.snakeSpawnWeight, 1, 1);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_RATTLESNAKE, class_1311.field_6294, NaturalistEntityTypes.RATTLESNAKE.get(), config.rattlesnakeSpawnWeight, 1, 1);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_CORAL_SNAKE, class_1311.field_6294, NaturalistEntityTypes.CORAL_SNAKE.get(), config.coralSnakeSpawnWeight, 1, 1);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_BLUEJAY, class_1311.field_6294, NaturalistEntityTypes.BLUEJAY.get(), config.bluejaySpawnWeight, 1, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_CANARY, class_1311.field_6294, NaturalistEntityTypes.CANARY.get(), config.canarySpawnWeight, 1, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_CARDINAL, class_1311.field_6294, NaturalistEntityTypes.CARDINAL.get(), config.cardinalSpawnWeight, 1, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_ROBIN, class_1311.field_6294, NaturalistEntityTypes.ROBIN.get(), config.robinSpawnWeight, 1, 4);
        this.addMobSpawn((class_6862<class_1959>)class_6908.field_36517, class_1311.field_6294, class_1299.field_6140, config.forestRabbitSpawnWeight, 2, 3);
        this.addMobSpawn((class_6862<class_1959>)class_6908.field_36517, class_1311.field_6294, class_1299.field_17943, config.forestFoxSpawnWeight, 2, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_RHINO, class_1311.field_6294, NaturalistEntityTypes.RHINO.get(), config.rhinoSpawnWeight, 1, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_LION, class_1311.field_6294, NaturalistEntityTypes.LION.get(), config.lionSpawnWeight, 3, 5);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_ELEPHANT, class_1311.field_6294, NaturalistEntityTypes.ELEPHANT.get(), config.elephantSpawnWeight, 2, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_ZEBRA, class_1311.field_6294, NaturalistEntityTypes.ZEBRA.get(), config.zebraSpawnWeight, 2, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_GIRAFFE, class_1311.field_6294, NaturalistEntityTypes.GIRAFFE.get(), config.giraffeSpawnWeight, 2, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_HIPPO, class_1311.field_6294, NaturalistEntityTypes.HIPPO.get(), config.hippoSpawnWeight, 3, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_VULTURE, class_1311.field_6294, NaturalistEntityTypes.VULTURE.get(), config.vultureSpawnWeight, 2, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_BOAR, class_1311.field_6294, NaturalistEntityTypes.BOAR.get(), config.boarSpawnWeight, 4, 4);
        if (config.removeSavannaFarmAnimals) {
            this.removeSpawn((class_6862<class_1959>)class_6908.field_37392, List.of(class_1299.field_6115, class_1299.field_6093, class_1299.field_6132, class_1299.field_6085));
        }
    }

    void addMobSpawn(class_6862<class_1959> tag, class_1311 mobCategory, class_1299<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        BiomeModifications.addSpawn(biomeSelector -> biomeSelector.hasTag(tag), (class_1311)mobCategory, entityType, (int)weight, (int)minGroupSize, (int)maxGroupSize);
    }

    void removeSpawn(class_6862<class_1959> tag, List<class_1299<?>> entityTypes) {
        entityTypes.forEach(entityType -> {
            class_2960 id = class_2378.field_11145.method_10221(entityType);
            Preconditions.checkState((id != class_2378.field_11145.method_10137() ? 1 : 0) != 0, (String)"Unregistered entity type: %s", (Object)entityType);
            BiomeModifications.create((class_2960)id).add(ModificationPhase.REMOVALS, biomeSelector -> biomeSelector.hasTag(tag), context -> context.getSpawnSettings().removeSpawnsOfEntityType(entityType));
        });
    }
}

